// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     chrome/browser/media/router/media_router.mojom
//

package org.chromium.mojom.media_router.interfaces;

public interface MediaRouteProvider extends org.chromium.mojo.bindings.Interface {

    public interface Proxy extends MediaRouteProvider, org.chromium.mojo.bindings.Interface.Proxy {
    }

    Manager<MediaRouteProvider, MediaRouteProvider.Proxy> MANAGER = MediaRouteProvider_Internal.MANAGER;

    void createRoute(String mediaSource, String sinkId, String originalPresentationId, String origin, int tabId, CreateRouteResponse callback);
    interface CreateRouteResponse extends org.chromium.mojo.bindings.Callbacks.Callback2<MediaRoute, String> { }

    void joinRoute(String mediaSource, String presentationId, String origin, int tabId, JoinRouteResponse callback);
    interface JoinRouteResponse extends org.chromium.mojo.bindings.Callbacks.Callback2<MediaRoute, String> { }

    void closeRoute(String routeId);

    void sendRouteMessage(String mediaRouteId, String message, SendRouteMessageResponse callback);
    interface SendRouteMessageResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<Boolean> { }

    void sendRouteBinaryMessage(String mediaRouteId, byte[] data, SendRouteBinaryMessageResponse callback);
    interface SendRouteBinaryMessageResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<Boolean> { }

    void startObservingMediaSinks(String mediaSource);

    void stopObservingMediaSinks(String mediaSource);

    void startObservingMediaRoutes();

    void stopObservingMediaRoutes();

    void listenForRouteMessages(String routeId, ListenForRouteMessagesResponse callback);
    interface ListenForRouteMessagesResponse extends org.chromium.mojo.bindings.Callbacks.Callback2<RouteMessage[], Boolean> { }

    void stopListeningForRouteMessages(String routeId);

    void onPresentationSessionDetached(String routeId);
}

